<?php

function sm_register_shortcode_handler_sm_contact_form() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_contact_form extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_contact_form_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_contact_form', 'sm_contact_form_func' );
	}
}

function sm_contact_form_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'contact-form', $view_params );
}

function sm_filter_contact_form_style( $scanned_tag, $exec ) {

	$allowed_input_tags = array( 'text', 'email', 'url', 'tel', 'number', 'textarea', 'date', 'select' );
	if ( $scanned_tag['basetype'] == 'submit' ) {
		$button_styles = explode( ' ', $GLOBALS['sm_contact_form7_button_style'] );
		foreach ( $button_styles as $key => $value ) {
			$scanned_tag['options'][] = 'class:' . $value;
		}
		if ( $GLOBALS['sm_contact_form7_button_color'] != '' )
			$scanned_tag['options'][] = 'class:' . $GLOBALS['sm_contact_form7_button_color'];
		if ( !empty( $GLOBALS['sm_contact_form7_button_shape'] ) )
			$scanned_tag['options'][] = 'class:' . $GLOBALS['sm_contact_form7_button_shape'];
		
	} else if ( in_array( $scanned_tag['basetype'], $allowed_input_tags ) ) {
		if ( !empty( $GLOBALS['sm_contact_form7_input_style'] ) )
			$scanned_tag['options'][] = 'class:' . $GLOBALS['sm_contact_form7_input_style'];
		if ( !empty( $GLOBALS['sm_contact_form7_input_shape'] ) )
			$scanned_tag['options'][] = 'class:' . $GLOBALS['sm_contact_form7_input_shape'];
	}

	return $scanned_tag;
}

add_filter( 'wpcf7_form_response_output', 'sm_form_response_output', 10, 4 );
function sm_form_response_output( $output, $class, $content, $this ) {
	
	$new_class = $current_class = 'wpcf7-response-output';	
	if ( !empty( $GLOBALS['sm_contact_form7_input_shape'] ) )
		$new_class .= ' ' . $GLOBALS['sm_contact_form7_input_shape'];
	
	return str_replace( $current_class, $new_class, $output );
}

/* Buttom Element as Contact Form 7 Submit */
function sm_filter_fowl_wpcf7_submit_button() {
	if( function_exists('wpcf7_remove_shortcode') ) {
		wpcf7_remove_shortcode('submit');
		wpcf7_add_shortcode( 'submit', 'sm_wpcf7_submit_shortcode_handler' );
	}
}
add_action( 'wpcf7_init','sm_filter_fowl_wpcf7_submit_button' , 99 );
function sm_wpcf7_submit_shortcode_handler( $tag ) {
	$tag = new WPCF7_Shortcode( $tag );

	$class = wpcf7_form_controls_class( $tag->type );

	$atts = array();

	$atts['class'] = $tag->get_class_option( $class );
	$atts['id'] = $tag->get_id_option();
	$atts['tabindex'] = $tag->get_option( 'tabindex', 'int', true );

	$value = isset( $tag->values[0] ) ? $tag->values[0] : '';

	if ( empty( $value ) )
		$value = esc_html__( 'Send', 'contact-form-7' );

	$atts['type'] = 'submit';
	//$atts['value'] = $value;

	$atts = wpcf7_format_atts( $atts );

	$html = sprintf( '<button %1$s>%2$s</button>', $atts, $value );

	return $html;
}

function sm_filter_wpcf7_form_name_attr( $name_attr ) {
	$name_attr = sm_shortcode_unique_id( "sm_contactform" );
	return $name_attr;
}
add_filter( 'wpcf7_form_name_attr', 'sm_filter_wpcf7_form_name_attr', 10, 2 );

sm_register_shortcode( array (
	'base' => 'sm_contact_form',
	'name' => esc_html__( 'Contact Form', 'semona-extension' ),
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Place Contact Form7 with style.', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-contact_form.png',
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Form title', 'semona-extension' ),
			'param_name' => 'title',
			'admin_label' => true,
			'description' => esc_html__( 'What text use as form title. Leave blank if no title is needed.', 'semona-extension' )
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Select a contact form', 'semona-extension' ),
			'param_name' => 'id',
			'value' => sm_get_contact_form_7_forms_array(),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Input Fields Style', 'semona-extension' ),
			'param_name' => 'input_style',
			'value' => sm_get_contact_form_input_styles_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Input Fields Shape', 'semona-extension' ),
			'param_name' => 'input_shape',
			'value' => sm_get_contact_form_input_shapes_array(),
			'std' => '',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Input Fields Background Color', 'semona-extension' ),
			'param_name' => 'input_bg_color',
			'description' => esc_html__( 'Leave blank to use default. (Background Color 2)', 'semona-extension' ),
			'dependency' => array(
				'element' => 'input_style',
				'value' => 'sm-style-solid',
			)
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Text Color', 'semona-extension' ),
			'param_name' => 'input_color',
			'description' => esc_html__( 'Leave blank to use default.', 'semona-extension' ),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Button Style', 'semona-extension' ),
			'param_name' => 'button_style',
			'value' => sm_get_contact_form_button_styles_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Button alignment', 'semona-extension' ),
			'param_name' => 'button_align',
			'value' => sm_get_contact_form_button_aligns_array(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Button Shape', 'semona-extension' ),
			'param_name' => 'button_shape',
			'value' => sm_get_button_shapes_array(),
			'dependency' => array(
				'element' => 'button_style',
				'value_not_equal_to' => 'sm-style-underline'
			)
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Text Color', 'semona-extension' ),
			'param_name' => 'underline_text_color',
			'dependency' => array(
				'element' => 'button_style',
				'value' => array( 'sm-style-underline' ) // Underline Style only
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Button Color', 'semona-extension' ),
			'param_name' => 'button_color',
			'value' => sm_get_preset_colors_array( true, true, false ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'dependency' => array(
				'element' => 'button_style',
				'value' => array( 'sm-style-modern sm-size-lg', 'sm-style-flat sm-size-lg', 'sm-style-3d sm-size-lg' )
			),
		),
	)
) );

